#include <iostream>
#include <algorithm>
#include <climits>

using namespace std;

pair<int, int> jarboli[1000000];
int najveci_levo[1000000];
int najveci_desno[1000000];

int udaljenost_levo(int i)
{
    if (najveci_levo[i] == - 1) return INT_MAX;
    return jarboli[i].first - jarboli[i].second + jarboli[najveci_levo[i]].first + jarboli[najveci_levo[i]].second;
}

int udaljenost_desno(int i) 
{
    if (najveci_desno[i] == - 1) return INT_MAX;
    return jarboli[i].second - jarboli[najveci_desno[i]].second + jarboli[najveci_desno[i]].first - jarboli[i].first;
}

int main() {
    int n;
    cin >> n;

    for (int i = 0; i<n; i++)
        cin >> jarboli[i].first;
    for (int i = 0; i<n; i++)
        cin >> jarboli[i].second;

    for (int i = 0; i<n; i++) {
        najveci_levo[i] = -1;
        najveci_desno[i] = -1;        
    }

    sort(jarboli, jarboli + n);

    for (int i = 1; i<n; i++) {
        if (jarboli[i].second <= jarboli[i-1].second) {
            najveci_levo[i] = i-1;
            if (jarboli[i].second == jarboli[i-1].second)
                najveci_desno[i-1] = i;
        } else {
            int a = i-1;
            
            while (a != -1 && jarboli[najveci_levo[a]].second <= jarboli[i].second) {
                najveci_desno[a] = i;
                a = najveci_levo[a];
            }

            if (a != -1) {
                najveci_levo[i] = a;
                if (jarboli[a].second == jarboli[i].second) 
                    najveci_desno[a] = i;
            }
        }
    }

    for (int i = 0; i<n; i++) {
        if (najveci_levo[i] == -1 && najveci_desno[i] == -1) {
            cout << -1 << "\n";
            continue;
        }

        cout << min(udaljenost_levo(i), udaljenost_desno(i)) << "\n";
    }

    return 0;
}